/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: EcatSoESSC_Functionlist.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    Ecat SoE SSC
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
      1        05.05.2009  SB
        Created

**************************************************************************************/
#ifndef __ECAT_SOESSC_FUNCTIONLIST_H
#define __ECAT_SOESSC_FUNCTIONLIST_H



/***************************************************************************************/
/* Ecat FoE function list, prototyes */

TLR_RESULT
TaskExit_EcatSoESSC(      void*     pvRsc);

void
TaskEnter_EcatSoESSC(     void*     pvInit);


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ECAT_SOE_SSC_STARTUP_PARAM_VERSION (1)

#ifndef TLR_TASK_ECAT_SOE_SSC
#define TLR_TASK_ECAT_SOE_SSC            ((TLR_TASKIDENTIFIER)0x00220001L)
#endif

/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** type of <code>ECAT_SOE_SSC_STARTUPPARAMETER_Ttag</code> */
typedef struct ECAT_SOE_SSC_STARTUPPARAMETER_Ttag  ECAT_SOE_SSC_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ECAT_SOE_SSC_STARTUPPARAMETER_Ttag      /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
};

/** @} */

/***************************************************************************************/
#endif /* #ifndef __ECAT_FOE_FUNCTIONLIST_H */
